/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.security;

import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWAddRemovePanel;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWParticipantListCellRenderer;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.security.IVWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.uicontrols.security.VWItemFilterPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VWFilteredUsersPanel
extends VWAddRemovePanel
implements IVWUsersAndGroupsPanel,
ActionListener {
    protected int m_nType = 0;
    protected VWItemFilterPanel m_itemFilterPanel;

    public VWFilteredUsersPanel(Container parentContainer, VWSession vwSession) {
        super(10, parentContainer, vwSession);
        this.enableSorting(1536);
        this.setAvailableItemName(VWResource.s_availableUsers);
        this.setSelectedItemName(VWResource.s_selectedUsers);
        this.initializeLists(null);
    }

    public void init(VWParticipantItem[] selectedParticipantItems) {
        try {
            this.initializeLists(selectedParticipantItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWParticipantItem[] getParticipants() {
        try {
            Object[] selectedItems = this.getSelectedItems();
            if (selectedItems != null && selectedItems.length > 0) {
                VWParticipantItem[] vwParticipantItems = new VWParticipantItem[selectedItems.length];
                for (int nIndex = 0; nIndex < selectedItems.length; ++nIndex) {
                    vwParticipantItems[nIndex] = (VWParticipantItem)selectedItems[nIndex];
                }
                return vwParticipantItems;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public void removeReferences() {
        this.m_vwSession = null;
        if (this.m_itemFilterPanel != null) {
            this.m_itemFilterPanel.removeActionListener(this);
            this.m_itemFilterPanel = null;
        }
        super.removeReferences();
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.m_itemFilterPanel)) {
                this.updateAvailableList(this.m_itemFilterPanel.getUserParticipantItems());
            } else {
                super.actionPerformed(event);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(JOptionPane.getFrameForComponent(this.m_parentContainer), ex.getLocalizedMessage(), 1);
        }
    }

    protected void addControls() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridwidth = 0;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 3, 3, 3);
            JPanel headerPanel = this.getHeaderPanel();
            if (headerPanel != null) {
                this.add((Component)headerPanel, gbCons);
            }
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 1;
            this.add((Component)this.createAvailableListPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            gbCons.anchor = 10;
            this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.anchor = 23;
            this.add((Component)this.createSelectedListPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createAvailableListPanel() {
        try {
            JPanel aListPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(3, 3, 0, 2);
            aListPanel.add((Component)this.m_availableLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_availableLabel, this, this.m_availableLabel.getText(), this.m_availableLabel.getText());
            this.m_availableLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbCons.gridy;
            JPanel panel = this.getTypeAheadPanel();
            if (panel != null) {
                aListPanel.add((Component)panel, gbCons);
            }
            this.m_itemFilterPanel = new VWItemFilterPanel(this.m_parentContainer, this.m_vwSession);
            this.m_itemFilterPanel.addActionListener(this);
            this.m_itemFilterPanel.requestFocus();
            aListPanel.add((Component)this.m_itemFilterPanel, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            this.m_availableList = new JList(new VWSortedListModel());
            this.m_availableList.addListSelectionListener(this);
            this.m_availableList.addMouseListener(new VWMouseAdapter(this));
            aListPanel.add((Component)new JScrollPane(this.m_availableList), gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_availableList, aListPanel, this.m_availableLabel.getText(), this.m_availableLabel.getText());
            VWAccessibilityHelper.setLabelFor(this.m_availableLabel, this.m_availableList);
            this.m_availableList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_availableList.addFocusListener(this);
            return aListPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createSelectedListPanel() {
        try {
            JPanel sListPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(3, 3, 0, 2);
            sListPanel.add((Component)this.m_selectedLabel, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_selectedLabel, this, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_removeButton = VWImageLoader.createToolBarButton("delete.gif", VWResource.s_delete, false);
            this.m_removeButton.addActionListener(this);
            sListPanel.add((Component)this.m_removeButton, gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_removeButton, this, VWResource.s_delete, VWResource.s_delete);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.gridwidth = 0;
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener(this);
            this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_selectedList.addFocusListener(this);
            sListPanel.add((Component)new JScrollPane(this.m_selectedList), gbCons);
            VWAccessibilityHelper.setLabelFor(this.m_selectedLabel, this.m_selectedList);
            VWAccessibilityHelper.setAccessibility(this.m_selectedList, sListPanel, this.m_selectedLabel.getText(), this.m_selectedLabel.getText());
            return sListPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel getHeaderPanel() {
        return null;
    }

    protected JPanel getTypeAheadPanel() {
        return null;
    }

    protected JPanel createAddRemoveButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 10;
            gbCons.fill = 0;
            gbCons.gridx = 0;
            gbCons.gridy = -1;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(3, 0, 3, 0);
            if (this.m_bShowMoveAllButtons) {
                this.m_addAllButton = new JButton(VWImageLoader.createImageIcon("addall.gif"));
                this.m_addAllButton.setDisabledIcon(VWImageLoader.createImageIcon("addall_d.gif"));
                this.m_addAllButton.setToolTipText(VWResource.s_addAll);
                this.m_addAllButton.setName("m_addAllButton_VWFilteredUsersPanel");
                this.m_addAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_addAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_addAllButton);
                VWAccessibilityHelper.setAccessibility(this.m_addAllButton, this, VWResource.s_addAll, VWResource.s_addAll);
                this.m_addAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                panel.add((Component)this.m_addAllButton, gbCons);
            }
            this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
            this.m_addButton.setDisabledIcon(VWImageLoader.createImageIcon("add_d.gif"));
            this.m_addButton.setToolTipText(VWResource.s_add);
            this.m_addButton.setName("m_addButton_VWFilteredUsersPanel");
            this.m_addButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_addButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_addButton);
            VWAccessibilityHelper.setAccessibility(this.m_addButton, this, VWResource.s_add, VWResource.s_add);
            this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_addButton, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    protected void initializeLists(Object[] selectedParticipants) {
        try {
            this.setListCellRenderer(new VWParticipantListCellRenderer());
            this.initializeLists(null, selectedParticipants);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void updateAvailableList(VWParticipantItem[] vwParticipantItems) {
        try {
            this.initializeLists(vwParticipantItems, this.getSelectedItems());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        return null;
    }
}

